$fn = 30;

shaftDiameter = 10.5;
shaftRadius = shaftDiameter/2;

screwDiameter = 3.1;
screwRadius = screwDiameter/2;
screwMargin = 3;

sideMargin = 5;
bottomMargin = 17;

totalLength = 30;
totalWidth = sideMargin+sideMargin+shaftDiameter;

shaftHoldingHeight = 10;
baseHeight = 0;

cornerBevelRadius = 1;

totalHeight = baseHeight+shaftHoldingHeight;

render() 
difference() {
	hull() {
		translate([cornerBevelRadius,cornerBevelRadius,0]) cylinder(r=cornerBevelRadius,h=totalHeight);
		translate([cornerBevelRadius,totalWidth-cornerBevelRadius,0]) cylinder(r=cornerBevelRadius,h=totalHeight);
		translate([totalLength-(cornerBevelRadius*2),totalWidth-cornerBevelRadius,0]) cylinder(r=cornerBevelRadius,h=totalHeight);
		translate([totalLength-(cornerBevelRadius*2),cornerBevelRadius,0]) cylinder(r=cornerBevelRadius,h=totalHeight);	
	}

	hull() {
		translate([-1,totalWidth/2,baseHeight]) cylinder(r=shaftRadius,h=totalHeight);
		translate([totalLength-(bottomMargin+shaftRadius),totalWidth/2,baseHeight]) cylinder(r=shaftRadius,h=totalHeight);	
	}


	// shaft screw
	translate([totalLength-(bottomMargin+shaftRadius)-(shaftRadius/2),-1,baseHeight+(shaftHoldingHeight/2)]) rotate([-90,0,0]) cylinder(r=screwRadius,h=sideMargin+2);
	translate([totalLength-(bottomMargin+shaftRadius)-(shaftRadius/2),totalWidth+1,baseHeight+(shaftHoldingHeight/2)]) rotate([90,0,0]) cylinder(r=screwRadius,h=sideMargin+2);

	// mount screw
	rotate([0,-90,0]) cylinder(r=screwRadius,h=sideMargin+2);
	
	translate([0,-1,totalHeight-5]) rotate([0,-45,0]) cube(size=[20,totalWidth+2,20]);


	translate([0,totalWidth/2,0.5+baseHeight+shaftHoldingHeight/2]) rotate([0,0,45]) cube(size=[shaftDiameter,shaftDiameter,shaftHoldingHeight+1],center=true);


	translate([totalLength+2,totalWidth/2,totalHeight/2]) {
		translate([0,-5,0]) rotate([0,-90,0]) cylinder(r=screwRadius,h=bottomMargin);
		translate([0,5,0]) rotate([0,-90,0]) cylinder(r=screwRadius,h=bottomMargin);
	}
	
}



