/**
\file SoftPWM.h
\brief This file has to be included by all modules that use SoftPWM.
*/

#include "softpwmconfig.h"

#define PINOFF(PORT,NR) PORT&=~(1 << NR)
#define PINON(PORT,NR) PORT|=(1 << NR)

void SoftPWMInit(void);
void SoftPWMSetR(uint8_t number, uint8_t value);
void SoftPWMSetG(uint8_t number, uint8_t value);
void SoftPWMSetB(uint8_t number, uint8_t value);
void SoftPWMSwapBuffers(void);
void SoftPWMClearBuf(void);
void SoftPWMEnable(void);
void SoftPWMDisable(void);

// lookup-tables
typedef uint8_t rgb_t[3];


