#include "avr/io.h"
#include "softpwmconfig.h"
 
temp = 16
ylow = 28
yhigh = 29
zlow = 30
zhigh = 31
 
.extern SoftPWM_SlotLenPtr
.extern SoftPWM_SlotStatesOutPtr

T1_COMPB_PRE1:
		// Stuff for short lenghts
		//; NextSegLen += OCR1B;  -> NextSegLen in Y
		in zlow,_SFR_IO_ADDR(OCR1BL)
		in zhigh,_SFR_IO_ADDR(OCR1BH)
		add ylow,zlow
		adc yhigh,zhigh	
		
		//; OCR1B = NextSegLen;
		out _SFR_IO_ADDR(OCR1BH),yhigh
		out _SFR_IO_ADDR(OCR1BL),ylow
		
		//; add some magic offset to NextSegLen
		adiw ylow,SoftPWM_MAGIC_OFFSET
		
		//; busy-wait...
T1_COMPB_WAIT1:
		in zlow,_SFR_IO_ADDR(TCNT1L)
		in zhigh,_SFR_IO_ADDR(TCNT1L)
		cp	zlow,ylow
		cpc zhigh,yhigh
		brlo	T1_COMPB_WAIT1
		rjmp	T1_COMPB_RESTART

 //; Short run: ~79 cycles -> min. value for counter = 10
.global TIMER1_COMPB_vect
TIMER1_COMPB_vect:
 
    push temp                      //; store registers
    in temp,_SFR_IO_ADDR(SREG)     //;
 //;   push temp
	push zlow
	push zhigh
	push ylow
	push yhigh

T1_COMPB_RESTART:	
	//; PORT_RED=*(SoftPWM_SlotStatesOutPtr++);
	//; PORT_GREEN=*(SoftPWM_SlotStatesOutPtr++);
	//; PORT_BLUE=*(SoftPWM_SlotStatesOutPtr++);
	lds zlow,SoftPWM_SlotStatesOutPtr
	lds zhigh,(SoftPWM_SlotStatesOutPtr+1)
	ld	ylow,Z+
	out _SFR_IO_ADDR(PORT_RED),ylow
	ld	ylow,Z+
	out _SFR_IO_ADDR(PORT_GREEN),ylow
	ld	ylow,Z+
	out _SFR_IO_ADDR(PORT_BLUE),ylow	
	sts	SoftPWM_SlotStatesOutPtr,zlow
	sts (SoftPWM_SlotStatesOutPtr+1),zhigh
	
	//; NextSegLen = pgm_read_word(SoftPWM_SlotLenPtr++);
	lds zlow,SoftPWM_SlotLenPtr
	lds zhigh,(SoftPWM_SlotLenPtr+1)	
	lpm	ylow,Z+
	lpm yhigh,Z+
	sts	SoftPWM_SlotLenPtr,zlow
	sts (SoftPWM_SlotLenPtr+1),zhigh
	
	//; Test if SlotLen is very short
	cpi	ylow,lo8(SoftPWM_NO_LEAVE_LEN)
	ldi zhigh,hi8(SoftPWM_NO_LEAVE_LEN)
	cpc yhigh,zhigh
    brlo	T1_COMPB_PRE1
	
T1_COMPB_SKIP1:	
	//; NextSegLen += OCR1B;  -> NextSegLen in Y
	in zlow,_SFR_IO_ADDR(OCR1BL)
	in zhigh,_SFR_IO_ADDR(OCR1BH)
	add ylow,zlow
	adc yhigh,zhigh
	
	// 	if(NextSegLen >= SoftPWM_TIMER_TOP_VALUE+1)
	cpi ylow,lo8(SoftPWM_TIMER_TOP_VALUE+1)
	ldi zhigh,hi8(SoftPWM_TIMER_TOP_VALUE+1)
	cpc yhigh,zhigh
	brsh	T1_COMPB_DOMORE1

T1_COMPB_END:	
	//; kill interrupt flag
	in	zhigh,_SFR_IO_ADDR(TIFR)
	sbr zhigh, (1<<OCF1B)
	out _SFR_IO_ADDR(TIFR),zhigh
	
	//; OCR1B = NextSegLen;
	out _SFR_IO_ADDR(OCR1BH),yhigh
	out _SFR_IO_ADDR(OCR1BL),ylow
	
	pop yhigh
	pop ylow
	pop zhigh
	pop zlow
 //   pop temp                       //; restore registers
    out _SFR_IO_ADDR(SREG),temp
    pop temp
    reti
 
T1_COMPB_DOMORE1: 
	//; NextSegLen -= (SoftPWM_TIMER_TOP_VALUE+1);
	subi	ylow,lo8(SoftPWM_TIMER_TOP_VALUE+1)
	sbci	yhigh,hi8(SoftPWM_TIMER_TOP_VALUE+1)
	
	//; SoftPWM_SlotLenPtr = SoftPWM_SlotLen;
	ldi	zlow,lo8(SoftPWM_SlotLen)
	ldi zhigh,hi8(SoftPWM_SlotLen)
	sts	SoftPWM_SlotLenPtr,zlow
	sts (SoftPWM_SlotLenPtr+1),zhigh	
	
	//; if(SoftPWM_Flags & (1<<SoftPWM_FLAG_BUF1OUT))...
	lds zlow,SoftPWM_Flags
	
	//; operate on low byte
	ldi zhigh,lo8(SoftPWM_SlotStates1)
	sbrs zlow,SoftPWM_FLAG_BUF1OUT
	ldi zhigh,lo8(SoftPWM_SlotStates2)
	sts SoftPWM_SlotStatesOutPtr,zhigh
	
	//; operate on high byte
	ldi zhigh,hi8(SoftPWM_SlotStates1)
	sbrs zlow,SoftPWM_FLAG_BUF1OUT
	ldi zhigh,hi8(SoftPWM_SlotStates2)
	sts (SoftPWM_SlotStatesOutPtr+1),zhigh	
 
	rjmp	T1_COMPB_END
 
.end

#if 0
/// This is the interrupt-vector for the timer0-compare-match-interrupt
ISR(TIMER1_COMPB_vect)
{
	uint16_t NextSegLen;
	
	PORT_RED=*(SoftPWM_SlotStatesOutPtr++);
	PORT_GREEN=*(SoftPWM_SlotStatesOutPtr++);
	PORT_BLUE=*(SoftPWM_SlotStatesOutPtr++);
	
	NextSegLen = pgm_read_word(SoftPWM_SlotLenPtr++);
	
	// if(NextSegLen < SoftPWM_NOINTLEAVELEN)
	
	NextSegLen += OCR1B;
	
	// If end reached, overflow and restart, change SlotBuffer here 
	if(NextSegLen > SoftPWM_TIMER_TOP_VALUE)
	{
		NextSegLen -= (SoftPWM_TIMER_TOP_VALUE+1);
	    SoftPWM_SlotLenPtr = SoftPWM_SlotLen;
	    if(SoftPWM_Flags & (1<<SoftPWM_FLAG_BUF1OUT))
	    {
		    SoftPWM_SlotStatesOutPtr = &SoftPWM_SlotStates1[0][0];
	    }
	    else
	    {
		    SoftPWM_SlotStatesOutPtr = &SoftPWM_SlotStates2[0][0];
	    }
	}
	
	OCR1B = NextSegLen;
}
#endif
