/**
\file SoftPWMConfig.h
\brief This file contains all definitions used to configure SoftPWM
*/

// Put only defines here because this file is included in ASM as well
//#define SoftPWM_3B_SLOTS
//#define SoftPWM_31_SLOTS
//#define SoftPWM_63_SLOTS
#define SoftPWM_127_SLOTS

#ifdef SoftPWM_3_SLOTS
	// This is the number of slots used, this is one less than brightness levels
	#define SoftPWM_SLOT_COUNT 3

	// This is the ordering of the slots
	#define SoftPWM_SLOT_ORDER 1,0,2

	// This are the lengths of the slots
	#define SoftPWM_SLOT_LEN 82,23,151

	// This is timer top value
	#define SoftPWM_TIMER_TOP_VALUE 255
#endif

#ifdef SoftPWM_3B_SLOTS
	// This is the number of slots used, this is one less than brightness levels
	#define SoftPWM_SLOT_COUNT 3

	// This is the ordering of the slots
	#define SoftPWM_SLOT_ORDER 1,0,2

	// This are the lengths of the slots
	#define SoftPWM_SLOT_LEN 16032,4460,29509

	// This is timer top value
	#define SoftPWM_TIMER_TOP_VALUE 50000
#endif

#ifdef SoftPWM_31_SLOTS
	// This is the number of slots used, this is one less than brightness levels
	#define SoftPWM_SLOT_COUNT 31

	// This is the ordering of the slots
	#define SoftPWM_SLOT_ORDER 15,7,23,3,19,11,27,1,17,9,25,5,21,13,29,0,16,8,24,4,20,12,28,2,18,10,26,6,22,14,30

	// This are the lengths of the slots
	#define SoftPWM_SLOT_LEN 1545,646,2545,259,2034,1080,3073,94,1787,858,2807,446,2287,1309,3343,26,1665,751,2675,350,2160,1193,3208,173,1910,968,2940,544,2416,1426,3480

	// This is timer top value
	#define SoftPWM_TIMER_TOP_VALUE 49997
#endif

#ifdef SoftPWM_63_SLOTS
	// This is the number of slots used, this is one less than brightness levels
	#define SoftPWM_SLOT_COUNT 63

	// This is the ordering of the slots
	#define SoftPWM_SLOT_ORDER 31,15,47,7,39,23,55,3,35,19,51,11,43,27,59,1,33,17,49,9,41,25,57,5,37,21,53,13,45,29,61,0,32,16,48,8,40,24,56,4,36,20,52,12,44,28,60,2,34,18,50,10,42,26,58,6,38,22,54,14,46,30,62

	// This are the lengths of the slots
	#define SoftPWM_SLOT_LEN 760,325,1244,136,997,535,1500,54,877,427,1371,227,1120,646,1630,20,818,375,1307,180,1058,590,1565,94,937,481,1435,275,1182,702,1696,6,789,350,1276,158,1028,562,1532,74,907,454,1403,251,1150,674,1663,36,848,401,1339,203,1089,618,1597,114,967,508,1467,300,1213,731,1729

	// This is timer top value
	#define SoftPWM_TIMER_TOP_VALUE 50000
#endif

#ifdef SoftPWM_127_SLOTS
	// This is the number of slots used, this is one less than brightness levels
	#define SoftPWM_SLOT_COUNT 127

	// This is the ordering of the slots
	#define SoftPWM_SLOT_ORDER 63,31,95,15,79,47,111,7,71,39,103,23,87,55,119,3,67,35,99,19,83,51,115,11,75,43,107,27,91,59,123,1,65,33,97,17,81,49,113,9,73,41,105,25,89,57,121,5,69,37,101,21,85,53,117,13,77,45,109,29,93,61,125,0,64,32,96,16,80,48,112,8,72,40,104,24,88,56,120,4,68,36,100,20,84,52,116,12,76,44,108,28,92,60,124,2,66,34,98,18,82,50,114,10,74,42,106,26,90,58,122,6,70,38,102,22,86,54,118,14,78,46,110,30,94,62,126

	// This are the lengths of the slots
	#define SoftPWM_SLOT_LEN 377,163,615,69,494,266,741,29,435,213,678,114,554,321,805,12,406,188,646,91,524,293,773,49,464,239,709,138,584,349,838,4,391,175,631,80,509,280,757,39,449,226,693,126,569,335,821,20,420,200,662,103,539,307,789,59,479,253,725,150,600,363,854,1,384,169,623,75,501,273,749,34,442,220,685,120,562,328,813,16,413,194,654,97,531,300,781,54,471,246,717,144,592,356,846,8,398,181,638,86,516,286,765,44,457,233,701,132,577,342,829,24,427,207,670,109,546,314,797,64,486,259,733,156,607,370,862

	// This is timer top value
	#define SoftPWM_TIMER_TOP_VALUE 49999
#endif

// If the slot length is lower than this don't leave interrupt
#define SoftPWM_NO_LEAVE_LEN	12

#define SoftPWM_MAGIC_OFFSET	2

// Brightness levels go from 0 to this value
#define SoftPWM_MAX_LEVEL 127

// PORTs and DDRs for red, green, blue
#define PORT_RED    PORTA
#define PORT_GREEN  PORTB
#define PORT_BLUE   PORTC
#define DDR_RED     DDRA
#define DDR_GREEN   DDRB
#define DDR_BLUE    DDRC

#define COMMONCONTROL_PORT PORTD
#define COMMONCONTROL_DDR DDRD
#define COMMONCONTROL_PIN PIND
#define COMMONCONTROL_NUMBER 3

// If 1, buf1 is used in interrupt after one slot-round is over and buf2 is active for input
#define     SoftPWM_FLAG_BUF1OUT    (0)