import processing.serial.*;

Buntich bt;
int MAX_PALETTE = 256;
color[] palette = new color[MAX_PALETTE];
float flameheight;
PFont fontA;
float moverX = 0;
float moverXH = 0;
float moverY = 0;
float moverYH = 0;
float moverSize = 4;
float moverSizer = 1;
float colorhue = 0;
float colorsat = 0;

void setup() {
  size(1000,600);
  frameRate(40);
  bt = new Buntich(0,0,40,100);
  for(int i=0;i<MAX_PALETTE;i++) {
    palette[i] = color(min((i*4),255),i,min(255,max(0,-192+i)*3)); 
  }
  background(0);
  // bt.enumerate(this, "COM3");
  bt.enumerate(this, "");  // Simulation only
  fontA = loadFont("LucidaConsole-8.vlw");
  textFont(fontA);
  
}


void draw() {
  background(0);
  colorMode(HSB);
  float r;
  for(r = 0; r<360.0; r+=1.0) {
    
    stroke((colorhue * 255 + (r/360.0)*256)%256,(colorsat * 255 + (r/360.0)*2)%256,255);
    line(moverX,moverY,moverX+sin(radians(r))*moverSize,moverY+cos(radians(r))*moverSize);
  }
  moverXH -= 0.02;
  if(moverXH < 0) moverXH = 2*PI;
  moverX = cos(moverXH) * 4 + 4;
  
  moverYH -= 0.03;
  if(moverYH < 0) moverYH = 2*PI;
  moverY = sin(moverYH) * 4 + 4;
  moverSize += moverSizer;
  if(moverSize > 4.0) moverSizer = -0.01;
  if(moverSize < 0.5) moverSizer = +0.01;
  
  colorhue += 0.1;
  if(colorhue > 1.0) colorhue = 0.0;
  colorsat += 0.001;
  if(colorsat > 1.0) colorsat = 0.0;

  fill(0);
  //text("Buntich HACKERSPACE-FFM", moverX, 6);

  colorMode(RGB);
  bt.display(); 
  //println(frameRate);
}

class Paletting {
  
}

class Buntich {
  int GetX, GetY, TargetX, TargetY;
  
  int PixelSizeX = 40;
  int PixelSizeY = 40;
  int PixelDistanceX = 10;
  int PixelDistanceY = 10;
  int PixelCountX = 16;
  int PixelCountY = 8;
  
  byte BuntichCount = 0;
  byte BuntichLinesCount = 0;
  
  byte BUNTICH_CMD_DISPLAY_DATA = 0x00;
  byte BUNTICH_CMD_DISPLAY_SYNC = 0x01;
  byte BUNTICH_CMD_ENUMERATE_RESET = 0x02;
  byte BUNTICH_CMD_ENUMERATE_ENUM = 0x03;
  byte BUNTICH_CMD_SENSOR_START = 0x04;
  byte BUNTICH_CMD_SENSOR_STOP = 0x05;
  byte BUNTICH_CMD_SENSOR_READ = 0x06;
  byte BUNTICH_BROADCAST_ADDRESS = byte(0xFF);
  byte BUNTICH_RESPONSE_OK = 0x01;
  byte BUNTICH_RESPONSE_TERMINATE = 0x02;
  byte BUNTICH_RESPONSE_ERROR = 0x03;
  
  char[][] BuntichOutBuf;
  byte SerialSendBuf[];
  int  SerialSendBufIndex;

  Serial SerialPort;
  
  Buntich(int rGetX, int rGetY, int rTargetX, int rTargetY) {
    GetX = rGetX;
    GetY = rGetY;
    TargetX = rTargetX;
    TargetY = rTargetY;
  }
  
  // Wait timeout milliseconds for at least mincount incoming characters.
  void wait_available(int mincount, float timeout) {
    float fstart = millis();
    while( ((millis() - fstart) < timeout) && (SerialPort.available() < mincount) ) {
    
    }
  }
  
  // Wait timeout milliseconds doing nothing
  void wait_time(float timeout) {
    float fstart = millis();
    while( (millis() - fstart) < timeout ) {
    
    }
  }
  
  void enumerate(PApplet parent, String portname) {
    
    println("Serial ports:");
    println(Serial.list());
    if(portname != "") {
      SerialPort = new Serial(parent, portname, 1000000);
    } else {
      SerialPort = null; // Turn serial here off
    }
    if(SerialPort != null) {
      for(int i=0;i<25;i++) {
        SerialPort.write(0);
      }
      SerialPort.write(BUNTICH_BROADCAST_ADDRESS);
      SerialPort.write(BUNTICH_CMD_ENUMERATE_RESET);
      wait_time(10);
      BuntichCount = 0;
      int stopit = 1;
      while (stopit == 1) {
        SerialPort.write(BUNTICH_BROADCAST_ADDRESS);
        SerialPort.write(BUNTICH_CMD_ENUMERATE_ENUM); 
        SerialPort.write(BuntichCount); 
        wait_available(1, 100);
        if(SerialPort.available()>=1) {
          byte[] inBuffer = new byte[SerialPort.available()];
          SerialPort.readBytes(inBuffer);
          if(inBuffer[0] == BUNTICH_RESPONSE_TERMINATE) {
            BuntichLinesCount++;
          }
          BuntichCount++;
        } else {
          stopit = 0;
          print("BuntichNodes = ");
          println(BuntichCount);
          println(BuntichLinesCount);
          if(BuntichCount > 0) {
            BuntichOutBuf = new char[BuntichCount][26];
            SerialSendBuf = new byte[BuntichCount*26 + 2];
            SerialPort.buffer(4);
          }
        }
      }
    } 
  }
    
  
  void display() {
    noStroke();
    ellipseMode(CORNER);
    color cp;
    for(int xi = 0; xi<PixelCountX; xi++) {
      for(int yi = 0; yi<PixelCountY; yi++) {
        cp = get(GetX + xi, GetY + yi);
        if(xi < BuntichCount) {
          BuntichOutBuf[xi][yi*3] = char(int(red(cp) / 2));
          BuntichOutBuf[xi][(yi*3)+1] = char(int(green(cp) / 2));
          BuntichOutBuf[xi][(yi*3)+2] = char(int(blue(cp) / 2));
        }
        fill(cp);
        ellipse(TargetX + xi * (PixelSizeX + PixelDistanceX), 
        TargetY + yi * (PixelSizeY + PixelDistanceY), PixelSizeX, PixelSizeY);
      }
    }
    if(SerialPort != null) {
    //  print(SerialPort.available());
    //  print(",");
      if(SerialPort.available()>=1) {
      //  byte[] inBuffer = new byte[SerialPort.available()];
      //  SerialPort.readBytes(inBuffer);
          SerialPort.clear();
      }
      
      SerialSendBufIndex = 0;
      SerialSendBuf[SerialSendBufIndex++] = BUNTICH_BROADCAST_ADDRESS;
      SerialSendBuf[SerialSendBufIndex++] = BUNTICH_CMD_DISPLAY_SYNC;

      for(int xi = 0; xi<BuntichCount; xi++) {
        
         SerialSendBuf[SerialSendBufIndex++] = byte(xi | int(0x0080));
         SerialSendBuf[SerialSendBufIndex++] = BUNTICH_CMD_DISPLAY_DATA;
         for(int yi = 0; yi<24; yi++) {
          SerialSendBuf[SerialSendBufIndex++] = byte(BuntichOutBuf[xi][yi]);
         }
      }

      SerialPort.write(SerialSendBuf);
    }
  }
  
}
  
