// Buntich Demo Stuff
import processing.serial.*;

Buntich bt;

final int pixel = 42;
int[] x = new int [pixel];
int[] y = new int [pixel];
int[] l = new int [pixel];

final int dd = 4;
final int dd2 = 256 / dd;


final int pix_w = 12;
final int pix_h = 12;

int[][] cr = new int [pix_w][pix_h];
int[][] cg = new int [pix_w][pix_h];
int[][] cb = new int [pix_w][pix_h];


void setup () {
  size(1000,600);
  frameRate(40);
  bt = new Buntich(0,0,40,100);

  background(0);
  //bt.enumerate(this, "COM3");
  bt.enumerate(this, "");  // Simulation only
}

int cr0, cg0, cb0;
int countdown = 0;

void draw () {
  if (countdown > 0) {
    for (int i = 0; i < pixel; i ++) {
      if (l[i] > 0) {
        l[i] --;
        cr[x[i]][y[i]] += (cr[x[i]][y[i]] < cr0) ? dd : 0;
        cr[x[i]][y[i]] -= (cr[x[i]][y[i]] > cr0) ? dd : 0;
        cg[x[i]][y[i]] += (cg[x[i]][y[i]] < cg0) ? dd : 0;
        cg[x[i]][y[i]] -= (cg[x[i]][y[i]] > cg0) ? dd : 0;
        cb[x[i]][y[i]] += (cb[x[i]][y[i]] < cb0) ? dd : 0;
        cb[x[i]][y[i]] -= (cb[x[i]][y[i]] > cb0) ? dd : 0;
        stroke(cr[x[i]][y[i]], cg[x[i]][y[i]], cb[x[i]][y[i]]);
        point(x[i], y[i]);
        if (cr[x[i]][y[i]] == cr0)
          if (cg[x[i]][y[i]] == cg0)
            if (cb[x[i]][y[i]] == cb0)
              l[i] = 0;
     } 
      else {
        l[i] = 20 + int(random(0, 40));
        x[i] = int(random(0, pix_w));
        y[i] = int(random(0, pix_h));
      }
      countdown --;
    }
  } 
  else {
    if (random(0, 10) > 8) {
      cr0 = 0; cg0 = 0; cb0 = 0;
      countdown = int(random(1500, 3500));
    } else {
      cr0 = dd * int(random(0, dd2));
      cg0 = dd * int(random(0, dd2));
      cb0 = dd * int(random(0, dd2));
      countdown = int(random(500, 2500));
    }
    for (int i = 0; i < pixel; i ++)
      l[i] = 0;
  }

  bt.display();
}

class Buntich {
  int GetX, GetY, TargetX, TargetY;

  int PixelSizeX = 40;
  int PixelSizeY = 40;
  int PixelDistanceX = 10;
  int PixelDistanceY = 10;
  int PixelCountX = 16;
  int PixelCountY = 8;

  byte BuntichCount = 0;
  byte BuntichLinesCount = 0;

  byte BUNTICH_CMD_DISPLAY_DATA = 0x00;
  byte BUNTICH_CMD_DISPLAY_SYNC = 0x01;
  byte BUNTICH_CMD_ENUMERATE_RESET = 0x02;
  byte BUNTICH_CMD_ENUMERATE_ENUM = 0x03;
  byte BUNTICH_CMD_SENSOR_START = 0x04;
  byte BUNTICH_CMD_SENSOR_STOP = 0x05;
  byte BUNTICH_CMD_SENSOR_READ = 0x06;
  byte BUNTICH_BROADCAST_ADDRESS = byte(0xFF);
  byte BUNTICH_RESPONSE_OK = 0x01;
  byte BUNTICH_RESPONSE_TERMINATE = 0x02;
  byte BUNTICH_RESPONSE_ERROR = 0x03;

  char[][] BuntichOutBuf;
  byte SerialSendBuf[];
  int  SerialSendBufIndex;

  Serial SerialPort;

  Buntich(int rGetX, int rGetY, int rTargetX, int rTargetY) {
    GetX = rGetX;
    GetY = rGetY;
    TargetX = rTargetX;
    TargetY = rTargetY;
  }

  // Wait timeout milliseconds for at least mincount incoming characters.
  void wait_available(int mincount, float timeout) {
    float fstart = millis();
    while( ((millis() - fstart) < timeout) && (SerialPort.available() < mincount) ) {
    }
  }

  // Wait timeout milliseconds doing nothing
  void wait_time(float timeout) {
    float fstart = millis();
    while( (millis() - fstart) < timeout ) {
    }
  }

  void enumerate(PApplet parent, String portname) {

    println("Serial ports:");
    println(Serial.list());
    if(portname != "") {
      SerialPort = new Serial(parent, portname, 250000);
    } 
    else {
      SerialPort = null; // Turn serial here off
    }
    if(SerialPort != null) {
      for(int i=0;i<25;i++) {
        SerialPort.write(0);
      }
      SerialPort.write(BUNTICH_BROADCAST_ADDRESS);
      SerialPort.write(BUNTICH_CMD_ENUMERATE_RESET);
      wait_time(10);
      BuntichCount = 0;
      int stopit = 1;
      while (stopit == 1) {
        SerialPort.write(BUNTICH_BROADCAST_ADDRESS);
        SerialPort.write(BUNTICH_CMD_ENUMERATE_ENUM); 
        SerialPort.write(BuntichCount); 
        wait_available(1, 100);
        if(SerialPort.available()>=1) {
          byte[] inBuffer = new byte[SerialPort.available()];
          SerialPort.readBytes(inBuffer);
          if(inBuffer[0] == BUNTICH_RESPONSE_TERMINATE) {
            BuntichLinesCount++;
          }
          BuntichCount++;
        } 
        else {
          stopit = 0;
          print("BuntichNodes = ");
          println(BuntichCount);
          println(BuntichLinesCount);
          if(BuntichCount > 0) {
            BuntichOutBuf = new char[BuntichCount][26];
            SerialSendBuf = new byte[BuntichCount*26 + 2];
            SerialPort.buffer(4);
          }
        }
      }
    }
  }


  void display() {
    noStroke();
    ellipseMode(CORNER);
    color cp;
    for(int xi = 0; xi<PixelCountX; xi++) {
      for(int yi = 0; yi<PixelCountY; yi++) {
        cp = get(GetX + xi, GetY + yi);
        if(xi < BuntichCount) {
          BuntichOutBuf[xi][yi*3] = char(int(red(cp) / 2));
          BuntichOutBuf[xi][(yi*3)+1] = char(int(green(cp) / 2));
          BuntichOutBuf[xi][(yi*3)+2] = char(int(blue(cp) / 2));
        }
        fill(cp);
        ellipse(TargetX + xi * (PixelSizeX + PixelDistanceX), 
        TargetY + yi * (PixelSizeY + PixelDistanceY), PixelSizeX, PixelSizeY);
      }
    }
    if(SerialPort != null) {
      //  print(SerialPort.available());
      //  print(",");
      if(SerialPort.available()>=1) {
        //  byte[] inBuffer = new byte[SerialPort.available()];
        //  SerialPort.readBytes(inBuffer);
        SerialPort.clear();
      }

      SerialSendBufIndex = 0;
      SerialSendBuf[SerialSendBufIndex++] = BUNTICH_BROADCAST_ADDRESS;
      SerialSendBuf[SerialSendBufIndex++] = BUNTICH_CMD_DISPLAY_SYNC;

      for(int xi = 0; xi<BuntichCount; xi++) {

        SerialSendBuf[SerialSendBufIndex++] = byte(xi | int(0x0080));
        SerialSendBuf[SerialSendBufIndex++] = BUNTICH_CMD_DISPLAY_DATA;
        for(int yi = 0; yi<24; yi++) {
          SerialSendBuf[SerialSendBufIndex++] = byte(BuntichOutBuf[xi][yi]);
        }
      }

      SerialPort.write(SerialSendBuf);
    }
  }
}

