class Paletting {
  int Mode = 0;
  float MaxVal = 255.0;
  
  Paletting(int inMode, float inMaxVal) {
    Mode = inMode;
    MaxVal = inMaxVal;
  }
  
  color Pcolor(float number) {
    float r=0.0,g=0.0,b=0.0;
    color c = color(0,0,0);
    color cfrom, cto;
    number = number / MaxVal;
    switch(Mode) {
      case 0:
        colorMode(RGB);
        number *= 2.0;
        b = constrain(number*255.0,0.0,255.0);
        g = constrain((number-1.0)*255.0,0.0,255.0);
        r = constrain((number-1.0)*255.0,0.0,255.0);
        c = color(r,g,b);
        break;
        
      case 1:
        colorMode(RGB);
        cfrom = color(0,0,128);
        cto   = color(255,255,255); 
        c = lerpColor(cfrom,cto,constrain(number,0.0,1.0));
        break;   
        
      case 2:
        colorMode(RGB);
        number *= 3.0;
        if(number <= 1.0) {
          cfrom = color(0,0,0);
          cto   = color(0,0,255);
        } else if(number <= 2.0) {
          cfrom = color(0,0,255);
          cto   = color(128,128,255); 
          number -= 1.0;       
        } else {
          cfrom = color(128,128,255);
          cto   = color(255,255,0);   
          number -= 2.0;      
        } 
        c = lerpColor(cfrom,cto,constrain(number,0.0,1.0));
        break;
        
      case 3:
        colorMode(RGB);
        int i = int(number * 255.0);
        c = color(min((i*4),255),i,min(255,max(0,-192+i)*3));         
        break;  
    } 
    return(c);    
  }
  
  void Pstroke(float number) {
    stroke(Pcolor(number));
  }
}
