// Classes for working with Buntich, will simulate buntich and control real hardware

import processing.serial.*;

// bt object is created here. Set options for simulation in parameters.
  Buntich bt = new Buntich(0,0,40,100, "COM8");
  // Buntich bt = new Buntich(0,0,50,50, ""); // Omit serial port for simulation only

class Buntich {
  int GetX, GetY, TargetX, TargetY;
  
  int PixelSizeX = 30;
  int PixelSizeY = 30;
  int PixelDistanceX = 2;
  int PixelDistanceY = 2;
  int PixelCountX = 16;
  int PixelCountY = 8;
  
  byte BuntichCount = 0;
  byte BuntichLinesCount = 0;
  
  byte BUNTICH_CMD_DISPLAY_DATA = 0x00;
  byte BUNTICH_CMD_DISPLAY_SYNC = 0x01;
  byte BUNTICH_CMD_ENUMERATE_RESET = 0x02;
  byte BUNTICH_CMD_ENUMERATE_ENUM = 0x03;
  byte BUNTICH_CMD_SENSOR_START = 0x04;
  byte BUNTICH_CMD_SENSOR_STOP = 0x05;
  byte BUNTICH_CMD_SENSOR_READ = 0x06;
  byte BUNTICH_BROADCAST_ADDRESS = byte(0xFF);
  byte BUNTICH_RESPONSE_OK = 0x01;
  byte BUNTICH_RESPONSE_TERMINATE = 0x02;
  byte BUNTICH_RESPONSE_ERROR = 0x03;
  
  char[][] BuntichOutBuf;
  byte SerialSendBuf[];
  int  SerialSendBufIndex;

  Serial SerialPort;
  String PortName;
  
  Buntich(int rGetX, int rGetY, int rTargetX, int rTargetY, String rPortName) {
    GetX = rGetX;
    GetY = rGetY;
    TargetX = rTargetX;
    TargetY = rTargetY;
    PortName = rPortName;
  }
  
  // Wait timeout milliseconds for at least mincount incoming characters.
  void wait_available(int mincount, float timeout) {
    float fstart = millis();
    while( ((millis() - fstart) < timeout) && (SerialPort.available() < mincount) ) {
    
    }
  }
  
  // Wait timeout milliseconds doing nothing
  void wait_time(float timeout) {
    float fstart = millis();
    while( (millis() - fstart) < timeout ) {
    
    }
  }
  
  // if serial port is given, open it and enumerate buntich coloums
  void enumerate(PApplet parent) {    
    println("Serial ports:");
    println(Serial.list());
    if(PortName != "") {
      SerialPort = new Serial(parent, PortName, 250000);
    } else {
      SerialPort = null; // Turn serial here off
    }
    if(SerialPort != null) {
      for(int i=0;i<25;i++) {
        SerialPort.write(0);
      }
      SerialPort.write(BUNTICH_BROADCAST_ADDRESS);
      SerialPort.write(BUNTICH_CMD_ENUMERATE_RESET);
      wait_time(10);
      BuntichCount = 0;
      int stopit = 1;
      while (stopit == 1) {
        SerialPort.write(BUNTICH_BROADCAST_ADDRESS);
        SerialPort.write(BUNTICH_CMD_ENUMERATE_ENUM); 
        SerialPort.write(BuntichCount); 
        wait_available(1, 100);
        if(SerialPort.available()>=1) {
          byte[] inBuffer = new byte[SerialPort.available()];
          SerialPort.readBytes(inBuffer);
          if(inBuffer[0] == BUNTICH_RESPONSE_TERMINATE) {
            BuntichLinesCount++;
          }
          BuntichCount++;
        } else {
          stopit = 0;
          print("BuntichNodes = ");
          println(BuntichCount);
          println(BuntichLinesCount);
          if(BuntichCount > 0) {
            BuntichOutBuf = new char[BuntichCount][26];
            SerialSendBuf = new byte[BuntichCount*26 + 2];
            SerialPort.buffer(4);
          }
        }
      }
    } 
  }
    
  
  void display() {
    noStroke(); smooth(); colorMode(RGB);
    rectMode(CORNER);
    color cp;
    int xi, yi, z=32;
    fill(64);
    rect(TargetX - (PixelSizeX + PixelDistanceX) , TargetY - (PixelSizeY + PixelDistanceY),
           17 * (PixelSizeX + PixelDistanceX), 9 * (PixelSizeY + PixelDistanceY));
    rectMode(CENTER); ellipseMode(CENTER); 
    for(xi = 0; xi<PixelCountX; xi++) {
      for(yi = 0; yi<PixelCountY; yi++) {
        cp = get(GetX + xi, GetY + yi);
        if(xi < BuntichCount) {
          BuntichOutBuf[xi][yi*3] = char(int(red(cp) / 2));
          BuntichOutBuf[xi][(yi*3)+1] = char(int(green(cp) / 2));
          BuntichOutBuf[xi][(yi*3)+2] = char(int(blue(cp) / 2));
        }
        //for(z = 1; z<32; z++) {
          fill(cp);
          rect(TargetX + xi * (PixelSizeX + PixelDistanceX), 
          TargetY + yi * (PixelSizeY + PixelDistanceY), (PixelSizeX * z)/32, (PixelSizeY * z)/32);
        //}
  
      }
    }
    
    // ´*** Refresh the real thing ***
    if(SerialPort != null) {
    //  print(SerialPort.available());
    //  print(",");
      if(SerialPort.available()>=1) {
      //  byte[] inBuffer = new byte[SerialPort.available()];
      //  SerialPort.readBytes(inBuffer);
          SerialPort.clear();
      }
      
      // Prepare serial data block in buffer first before sending for performance reasons
      SerialSendBufIndex = 0;
      SerialSendBuf[SerialSendBufIndex++] = BUNTICH_BROADCAST_ADDRESS;
      SerialSendBuf[SerialSendBufIndex++] = BUNTICH_CMD_DISPLAY_SYNC;

      for(xi = 0; xi<BuntichCount; xi++) {
        
         SerialSendBuf[SerialSendBufIndex++] = byte(xi | int(0x0080));
         SerialSendBuf[SerialSendBufIndex++] = BUNTICH_CMD_DISPLAY_DATA;
         for(yi = 0; yi<24; yi++) {
          SerialSendBuf[SerialSendBufIndex++] = byte(BuntichOutBuf[xi][yi]);
         }
      }

      SerialPort.write(SerialSendBuf);
    }
  }
  
}
