/*
HackerspaceActivityMonitor https://www.hackerspace-ffm.de/wiki/index.php?title=HackffmActivitySensors

ATmega328 (Arduino UNO), see http://arduino.cc/it/Hacking/PinMapping168 with:
 PIR on 2 (INT0)
 BUTTON on 3 (INT1)
 Microphone-Modul on A0
 WizNET W5100 Modul on SPI (11,12,13) and CS on 10 and /RESET on A3
 LED as light sensor between Anode=7 Cathode=8 
 DHT11 as temp/humidity sensor on 4
 Status LEDs red on 6, green on 5

pachube.com:
 Feed:54260:**key**
 
Demonstrates use of the ERxPachube library. 
Push local sensor data to Pachube server.
If you don't have a Pachube account, register one first (http://www.pachube.com/).

To run this sketch, you need:
 1. Create a same feed as http://www.pachube.com/feeds/23408
    (A manual feed with three data streams with ids 0, 1, 2.)
 2. Use your API key to replace the space holer PACHUBE_API_KEY below. 
 3. Use your feed id to replace the space holer feed id 23408 below. 

Circuit:
* Ethernet shield attached to pins 10, 11, 12, 13

* Created 22 April 2011
* By Jeffrey Sun
* http://code.google.com/p/pachubelibrary/

*/
#include <avr/wdt.h>
#include <Arduino.h>
#include <HardwareSerial.h>
#include <ERxPachube.h>
#include <Ethernet.h>
#include <SPI.h>
#include "DHT.h"

byte mac[] = { 0x90, 0xA2, 0xDA, 0x11, 0x22, 0x33}; // make sure this is unique on your network

#define DHTPIN 4     // what pin we're connected to

// Uncomment whatever type you're using!
#define DHTTYPE DHT11   // DHT 11 
//#define DHTTYPE DHT22   // DHT 22  (AM2302)
//#define DHTTYPE DHT21   // DHT 21 (AM2301)

// Connect pin 1 (on the left) of the sensor to +5V
// Connect pin 2 of the sensor to whatever your DHTPIN is
// Connect pin 4 (on the right) of the sensor to GROUND
// Connect a 10K resistor from pin 2 (data) to pin 1 (power) of the sensor

DHT dht(DHTPIN, DHTTYPE);

#define PACHUBE_API_KEY				"*put_key_here*" // fill in your API key PACHUBE_API_KEY
#define PACHUBE_FEED_ID				54260 // fill in your feed id

ERxPachubeDataOut dataout(PACHUBE_API_KEY, PACHUBE_FEED_ID);

void PrintDataStream(const ERxPachube& pachube);

// Led, button and PIR port here (PIR and BUTTON must be interrupt pin!)
const int ledGreen = 5;
const int ledRed = 6;
const int PIR = 2;
const int BUTTON = 3;



int errorcount = 0;

volatile int intPIRCounter = 0;
volatile int intBUTTONCounter = 0;
int PIRCounter = 0;
int BUTTONCounter = 0;

// Counters are incremented by hardware interrupt
void PIRCount() { intPIRCounter++; }
void BUTTONCount() { intBUTTONCounter++; }

// test if one minute is over and store and reset counter
void CountMinuteReset() {
  static unsigned long timeLast = 0;
  if(millis() > (timeLast + 60000)) {
    timeLast += 60000;
    noInterrupts();
    PIRCounter = intPIRCounter;
    BUTTONCounter = intBUTTONCounter;
    intPIRCounter = 0;
    intBUTTONCounter = 0;
    interrupts();
    Serial.println("cmr");
  }
}
  
double getlight() {
  const int ledPinA = 7;
  const int ledPinK = 8;
  unsigned long timeStart, timeEnd;  
  pinMode(ledPinA, OUTPUT);
  pinMode(ledPinK, OUTPUT);
  digitalWrite(ledPinA, LOW);
  digitalWrite(ledPinK, HIGH);
  delay(1);
  pinMode(ledPinK, INPUT);
  
  timeStart = micros();
  digitalWrite(ledPinK, LOW);
  
  // Warning: this can take forever! Program can get stuck here if pin gets never low.
  while(digitalRead(ledPinK) == HIGH) {}
  
  timeEnd = micros();
  
  return(log10(1000000.0/(double)(timeEnd - timeStart)));
}

double getnoise() {
    unsigned long  l = 0;
    for(int i=0;i<10000;i++) { 
      l += analogRead(0);
    }
    return(log10(((double)l/10000.0)+1.0));
}

void setup() {
    //  wdt_enable(WDTO_8S);
      wdt_reset();
	Serial.begin(9600);

      pinMode(ledGreen, OUTPUT);
      pinMode(ledRed, OUTPUT);
      pinMode(PIR, INPUT);
      pinMode(BUTTON, INPUT);
      digitalWrite(PIR, HIGH);
      digitalWrite(BUTTON, HIGH);
      
      // Reset ETH (for modified module with extra reset input connected to arduino pin A3)
      pinMode(A3, OUTPUT); 
      digitalWrite(A3, LOW);
      delay(100);
      digitalWrite(A3, HIGH);      
 	Ethernet.begin(mac);

      Serial.print("My IP address: ");
      for (byte thisByte = 0; thisByte < 4; thisByte++) {
        // print the value of each byte of the IP address:
        Serial.print(Ethernet.localIP()[thisByte], DEC);
        Serial.print("."); 
      }
      Serial.println();

	dataout.addData(0);
	dataout.addData(1);
	dataout.addData(2);
        dataout.addData(3);
        dataout.addData(4);
        dataout.addData(5);
        
      attachInterrupt(0,PIRCount,RISING);
      attachInterrupt(1,BUTTONCount,FALLING);
      
}

void loop() {
        int status = 200;
        float f;
        digitalWrite(ledGreen, HIGH);
	Serial.println("+++++++++++++++++++++++++++++++++++++++++++++++++");
        CountMinuteReset();
        
        // Read from DHT, update only if a number is returned
        f = dht.readTemperature();
        if(!isnan(f)) dataout.updateData(0, f);
        f = dht.readHumidity();
        if(!isnan(f)) dataout.updateData(1, f);

	dataout.updateData(2, (float)(getnoise()));
	dataout.updateData(3, (float)getlight());
        dataout.updateData(4, (float)PIRCounter);
        dataout.updateData(5, (float)BUTTONCounter);
	status = dataout.updatePachube();

	Serial.print("sync status code <OK == 200> => ");
	Serial.println(status);
        if(status != 200) {
          digitalWrite(ledRed, HIGH);
          errorcount++;
          if(errorcount > 10) {
            cli();
            asm volatile ("jmp 0x0000"); 
          }
        }
        else {
          digitalWrite(ledRed, LOW);
          errorcount=0;
        }
        // Reset every hour (3 600 000 ms) -> doesn't work, because get stuck in bootloader
   /*     if(millis() > 60000UL) {
           cli();
          for(;;) {} 
        } */
	PrintDataStream(dataout);
        digitalWrite(ledGreen, LOW);
        wdt_reset();
        delay(5000);
        wdt_reset();
}

void PrintDataStream(const ERxPachube& pachube)
{
	unsigned int count = pachube.countDatastreams();
	Serial.print("data count=> ");
	Serial.println(count);

	Serial.println("<id>,<value>");
	for(unsigned int i = 0; i < count; i++)
	{
		Serial.print(pachube.getIdByIndex(i));
		Serial.print(",");
		Serial.print(pachube.getValueByIndex(i));
		Serial.println();
	}
}
