#!/usr/bin/python
import time
import pygame
import pygame.camera
import subprocess
import thread
import datetime
from pygame.locals import *
from thread import start_new_thread, allocate_lock
from wikitools import wiki
from wikitools import wikifile
from wikitools import api
from wikitools import page
import poster

num_threads = 0
thread_started = False
lock = allocate_lock()
analogVal = [1,3,37]

def update_wiki(bildL, bildR, analog):
    # create a Wiki object http://hackerspace-ffm.de/wiki/index.php?title=Wackelbildblog
    site = wiki.Wiki("http://hackerspace-ffm.de/wiki/api.php") 
    site.login("wackelbildprotokollator", "x")
    #print site.isLoggedIn()

    # Get blog
    wackelblog = page.Page(site, "Wackelbildblog")
    wikiblogtext = wackelblog.getWikiText()

    # Modify blog
    wbttarget = "<!--WBPInsertTarget-->"
    wbttargetstart = wikiblogtext.find(wbttarget)
    wikiblogtext_part1 = wikiblogtext[:wbttargetstart+len(wbttarget)]
    wikiblogtext_part2 = wikiblogtext[wbttargetstart+len(wbttarget):]

    # Add new entry
    wikiblogentry = "\n|-\n|<wackelbild src1=\"http://hackerspace-ffm.de/wiki/images/"
    wikiblogentry += bildL + "\" src2=\"http://hackerspace-ffm.de/wiki/images/"
    wikiblogentry += bildR + "\"></wackelbild>\n"
    wikiblogentry += "| " + str(analog[0]) + "\n"
    wikiblogentry += "| " + str(analog[1]) + "\n"
    wikiblogentry += "| " + str(analog[2]) 
    wikiblogtext = wikiblogtext_part1 + wikiblogentry + wikiblogtext_part2

    # Store blog
    wackelblog.edit(text=wikiblogtext)

    # Store pictures
    testImage = wikifile.File(wiki=site, title="Datei:"+bildL)
    testImage.upload(fileobj=open(bildL, "rb"), ignorewarnings=True) 
    testImage = wikifile.File(wiki=site, title="Datei:"+bildR)
    testImage.upload(fileobj=open(bildR, "rb"), ignorewarnings=True) 

    return 0

def hol_bild( cam_id, filename ):
    global num_threads, thread_started
    lock.acquire()
    num_threads += 1
    thread_started = True
    lock.release()
    
    if cam_id:
        print "0"
    pygame.camera.init()
    camlist = pygame.camera.list_cameras()
    cam = pygame.camera.Camera(camlist[cam_id],(640,480))
    if cam_id:
        print "1"
    cam.start()
    time.sleep(0)
    if cam_id:
        print "2"
    pic = cam.get_image()
    time.sleep(0)
    pic = cam.get_image()
    time.sleep(0)
    if cam_id:
        print "3"
    pic = cam.get_image()
    if cam_id:
        print "4"
    cam.stop()
    if cam_id:
        print "5"
    pygame.image.save(pic,filename)
    if cam_id:
        print "6"
    
    lock.acquire()
    num_threads -= 1
    lock.release()    
    return 0

subprocess.call("v4l2-ctl -d /dev/video0 --set-ctrl=brightness=120,contrast=10,saturation=150,exposure_auto=3,white_balance_temperature_auto=1", shell=True)
subprocess.call("v4l2-ctl -d /dev/video1 --set-ctrl=brightness=120,contrast=10,saturation=150,exposure_auto=3,white_balance_temperature_auto=1", shell=True)
subprocess.call("v4l2-ctl -d /dev/video0 --set-ctrl=brightness=120,contrast=10,saturation=150,exposure_auto=3", shell=True)
subprocess.call("v4l2-ctl -d /dev/video1 --set-ctrl=brightness=120,contrast=10,saturation=150,exposure_auto=3", shell=True)

#video0: 120 10 150 ,white_balance_temperature=57343
# WBPict_20140302214222.jpg
zeitstempel = datetime.datetime.now().strftime("%Y%m%d%H%M%S")
bild_links  = 'WBPict_'+zeitstempel+'L.jpg'
bild_rechts = 'WBPict_'+zeitstempel+'R.jpg'

try:
    thread.start_new_thread( hol_bild, (0, bild_links, ) )
    thread.start_new_thread( hol_bild, (1, bild_rechts, ) )
except:
    print "Error: unable to start thread"

while not thread_started:
    pass
while num_threads > 0:
    pass
 
update_wiki(bild_links, bild_rechts, analogVal) 
