/*
Open SCAD library www.openscad.org by ulrich.baer+openscad@gmail.com
Copy this file into your libaries directory (File » schow Library)
[https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Libraries]

Use it by starting your project with including the library.
All needed Information will be displayed in your console window, you may need to make that bigger.
Write:
include<ub.scad>   // no ";" [https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Include_Statement]
name="my project"; // use texton=0 to hide - the name will never be rendered

140|17 Changelog - beta 4.7
140|17 ADD Text - beta 4.7
141|17 ADD show 
164|17 ADD Bogen CHG Schnitt rotation default - beta 4.9
165|17 ADD Gewinde - beta 5
169|17 CHG Polar - beta 5.01
171|17 ADD Dreieck - beta5.1
179|17 CHG t0↦-t0  - beta5.11
180|17 CHG ADD Freiwinkel  - beta 5.2
182|17 CHG Polar ADD dr - beta 5.21
183|17 CHG Halbrund ADD parameter - beta 5.22
184|17 ADD Achshalter -beta 5.3
185|17 CHG Luer ADD lock ADD !male beta 5.41
187|17 CHG Ring ID OD CD - CHG Pille l corrected! DEL Stabhalter beta 5.5
189|17 CHG Achshalter ADD MutterSpiel - β5.51
202|17 ADD Sinuskoerpe, ADD color - β5.6
208|17 CHG Bogen fn=  -β5.7
211|17 CHG Kegel ADD center - β5.8
213|17 ADD Col for color  - β5.9
216|17 ADD $fn=fn, CHG Dreieck ADD Winkel -β6.0
226|17 ADD Kehle β6.1
232|17 ADD Gardena β6.2
237|17 ADD Kegelmantel β6.3
238|17 ADD Kugelmantel ADD Halb β6.4
240|17 ADD Klon β6.5
241|17 ADD Rohr ADD Drehpunkt β6.6

*/

//libraries direkt (program folder\oscad\libaries) !
Version="β6.6";
name="Projekt B";
nozzle=0.605;
layer=0.09;// one step = 0.03 (6mm/200)
function l(x)=x*layer;
function n(x)=x*nozzle;
function Inn6eck(durchmesser)=durchmesser/(sqrt(3)/2);//delete!
function In6eck(durchmesser)=durchmesser/(sqrt(3)/2);
function In4eck(durchmesser)=2*sqrt(2*pow(durchmesser/2,2));
fn=72;
$fn=fn;
anima=0;
tset=0;
texton=1;
t=anima?$t:tset;
t0=anima?$t*-360:tset*-360;
t1=anima?sin($t*360):tset;
t2=anima?sin($t*180):tset;
spiel=0.25;
co=["silver","lightgrey","darkgrey","grey","slategrey","red","orange","green","cyan","lightblue","blue","purple",[.8,.8,.8,.3],[.8,.8,.8,.6]];

vpt=[0,0,0];
vpr=[ 55.00, 0.00, 25.00 ];
vpd=150;
vp=0;
$vpr=vp?vpr:undef;    
$vpt=vp?vpt:undef;
$vpd=vp?vpd:undef;
messpunkt=+0;//1 für aktiv
help=1;
show=0;

%if (texton)T(20,-30,25)R(90)color("slategrey")text(name,font="DejaVusans:style=bold",halign="left",size=3,$fn=100);

echo();
echo    ("         ••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••");
echo    ("     •••••••••••••••••••••••••••• UB (system libary) included!•••••••••••••••••••••••••");
echo(str("••• Version: ",Version,"  ———  Layerhöhe: ",l(1),"  –v– ∅ Nozzlediameter: ",n(1)," ••• fn=",fn,"••• Spiel: ",spiel," •••"));
if (!help)echo    ("                                    ••••••••••           use: help=1;       •••••••••••    ");
if (help)
{
echo(str("•••••••••• Help is on! (help=1)   ••• show=",show," ••••••••••••••••••••••••"));
echo();    
echo    ("•••••••••• Funktionen:   •••••••••••••••••••••••••••••••••••••••••••");
echo    ("••• l(x)//Layer  •••  n(x)//Nozzledurchmesser   •••");
echo    ("••• In6eck(durchmesser) •••");
echo    ("••• In4eck(durchmesser) •••"); 
echo();    
echo    ("•••••••••• Objektmodifikatoren:   •••••••••••••••••••••••••••••••••");
echo    ("•••• T(x=0,y=0,z=0) ••• R(x=0,y=0,z=0)  ••");
echo    ("•••• Schnitt(on=1,r=0,x=0,y=0,z=0,rx=0,ry=0,sizex=200,sizey=200,sizez=50)Objekt  ••");    
echo    ("•••• [21] Linear(es=1,s=100,e=2,x=1,y=0,z=0,r=0,re=0,center=0,cx=0,cy=0,cz=0 ••");   
echo    ("•••• [22] Polar(e=3,x=0,y=0,r=0,re=0,n=1,end=360,dr=0)dr=delta element rotation  ••");
echo    ("•••• [23] Klon(tx=10,ty=0,tz=0,rx=0,ry=0,rz=0) Objekt  ••");
echo    ("•••• [24] Halb(i,x=0,y=0,z=1)Objekt      ••");
echo    ("•••• [25] Drehpunkt(rx=0,ry=0,rz=0,x=0,y=0,z=0,messpunkt=1)Objekt      ••");    
echo    ("•••• [26] Gewinde(d=20,s=1.5,w=5,g=1,fn=3,r=0,gd=1.75,detail=5,tz=0,n=1) steigung,windung,gänge,gangdurchmesser      ••");
echo    ("•••• [200]Riemenscheibe(e=40,radius=25,nockendurchmesser1=2,nockendurchmesser2=2,hoehe=8)Objekt •••••");
echo    ("•••• [201]Servokopf()Objekt  ••");
echo    ("•••• [202]Halbrund(h=15,d=3+2*spiel,x=1.0,n=1)Objekt mikroGetriebemotor Wellenaufnahme  ••");

    
    
    
echo();    
echo    ("•••••••••• Objekte:   •••••••••••••••••••••••••••••••••••••••••••••");


echo    ("•• [300] Kugelmantel(d=20,rand=n(2),fn=fn); ••••");

echo    ("•• [30] Kegel (d1=12,d2=6,v=1,fn=fn,n=1)  ••• [31]MK(d1=12,d2=6,v=19.5)//v=Steigung ••••");
echo    ("•• [301] Kegelmantel (d=10,d2=5,v=1,rand=n(2),loch=4.5) ••••");
echo    ("•• [32] Ring(hoehe=5,rand=5,durchmesser=20,cd=1,center=false,fn=fn,n=1) cd=1,0,-1  ••••");
echo    ("•• [33] Torus(trx=10,d=5,a=360,fn=150,fn2=50,r=0,n=1) ••••");
echo    ("•• [34] Torus2(m=10,trx=10,a=1,rq=1,d=5,w=2)//m=feinheit,trx = abstand mitte,a = sin verschiebung , rq=mplitude, w wellen •••••");
echo    ("•• [35] Pille(l=10,d=5,fn=fn,center=1,n=1) •••• ");
echo    ("•• [36] Twins(h=1,d=0,d11=10,d12=10,d21=10,d22=10,l=20,r=0,fn=60,center=0,sca=+0) ••••");
echo    ("•• [37] Kehle(rad=2.5,dia=0,l=20,angle=360,fn=fn,spiel=spiel)••••");

echo    ("•• [38] Glied(l=12,spiel=0.5,la=+1.5,fn=20) ••• [39][40]DGlied0/1(l1=12,l2=12,la=+1.5) ••••");   
echo    ("•• [41] Luer(male=1,lock=1,slip=1) ••••"); 
echo    ("•• [42] Gardena() ••••"); 
echo    ("•• [43] Servotraeger(SON=1) ••• Servo(r,narbe) ••••");  
echo    ("•• [44] Inkreis(h=5,d=5.5,eck=6,kreis=0,fn=fn,n=1) ••• Knochen(l=+15,d=3,d2=5,b=0,fn=36)   ••••");

echo    ("•• [46] Text(text=»«,size=5,h=0,cx=0,cy=0,cz=0,center=0)••••");
echo    ("•• [47] W5(kurv=15,arms=3,detail=.3,h=50,tz=+0,start=0.7,end=13.7,topdiameter=1,topenddiameter=1,bottomenddiameter=+2)••••");
echo    ("•• [48] Imprint(txt1=1,radius=20,abstand=7,rotz=-2,h=l(2),rotx=0,roty=0,stauchx=0,stauchy=0,txt0=›,txt2=‹)        ••••");
echo    ("•• [49] Bogen(grad=90,rad=5,d=3,l1=10,l2=12,fn=fn)        ••••");

echo    ("•• [50] Rohr(grad=90,rad=5,d=8,l1=10,l2=12,fn=fn,rand=n(2))••••");


echo    ("•• [51] Dreieck(h=10,ha=10,s=1,n=1,c=0)  s=skaliert  c=center   ••••");
echo    ("•• [52] Freiwinkel(w=60,h=5)   ••••");
echo    ("•• [53] Achshalter(laenge=30,achse=+5,schraube=3,mutter=5.5,schraubenabstand=15,hoehe=8,fn=fn) ••••");
echo    ("•• [54] Sinuskoerper(h=10,d=33,rand=2,randamp=1,randw=4,amp=1.5,w=4,detail=3,vers=0)  amp=Amplitude, w=Wellen, vers=versatz ••••");

echo    ("•• [60] Glied3(l)  ••• [61] Gelenk(l,w) ••• ••••••");



echo    ("•••••••••• Schalter: messpunkt=0 •••vp=0•••anima=0•••texton=1•••help=1••••••••••••••••••••••••••");
}
echo    ("   ••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••");
echo();
if(anima)echo(str("Zeit t0:",t0));
if(anima)echo(str("Zeit t1:",t1));
if(anima)echo(str("Zeit t2:",t2));
if (vp)echo (str("Viewportcontrol vpr: ",$vpr));
if (vp)echo (str("Viewportcontrol vpt: ",$vpt));    
if (vp)echo (str("Viewportcontrol vpd: ",$vpd)); 
if(vp)echo    ("••••  vp on  •••••••••••••••••••••••••••••••");
if(anima)echo ("••••  anima on! tset=0 t=0->1 || t0=0->360 || t1=-1<—>1 || t2=0<—>1   •••••••••••••••••");    

//show=$t*100;


*Servokopf()cylinder(1,d=8,$fn=36);
*Stabhalter();
*Torus();
*Glied();
*DGlied1();
*Bogen(180);
*Gewinde(21,g=2,s=8,w=2,r=0,fn=3);


%color([0.6,+0.0,0.9,0.8]){
if (show==61)Gelenk();      
if (show==60)Glied(); 
    
if (show==54) Sinuskoerper();   
if (show==53) Achshalter();    
if (show==52) Freiwinkel();
if (show==51) Dreieck();    
if (show==50) Rohr();
if (show==49)Bogen(grad=90,rad=5,d=3,l1=10,l2=12);
if (show==48)Imprint(txt1="››»»Rundherrummmm»»››",abstand=17.8,radius=20,rotz=-27,h=l(2),rotx=0,roty=0,stauchx=0,stauchy=0,txt0=" ",txt2=" ");
if (show==47)W5(kurv=15,arms=3,detail=.3,h=50,tz=+0,start=0.7,end=13.7,topdiameter=1,bottomenddiameter=+2);//Spiralarm   
if (show==46)Text(text="»DEMO«",size=5,h=0,cx=0,cy=0,cz=0,center=0,radius=0);    
if (show==45)Bitaufnahme();
if (show==44)Inkreis();    
if (show==43)Servotraeger(SON=1);
if (show==42)Gardena();    
if (show==41)Luer();
if (show==40)DGlied1();    
if (show==39)DGlied0();
if (show==38)Glied(); 
if (show==37)Kehle(); 
if (show==36)Twins(); 
if (show==35)Pille();
if (show==34)Torus2();    
if (show==33)Torus();
if (show==32)Ring();
if (show==31)MK();
if (show==301)Kegelmantel();
if (show==30)Kegel();
if (show==300)Kugelmantel();    
if (show==202)Halbrund(); 
if (show==26)Gewinde(); 
if (show==25)Drehpunkt(x=15,y=2,z=-8,rx=20,ry=20,rz=20,messpunkt=1)cube(5);
if (show==24)Halb()sphere(20);   
if (show==23)Klon(tx=10)cube(20);     
if (show==22)Polar(x=10,y=10)cube(5);    
if (show==21)Linear(es=0.5,s=1.0,e=4,x=90,y=0,z=0,r=0,re=0,center=+1,cx=+0)cube(5);

   
if (show==2){cylinder(10,d=n(1),$fn=36,center=true);echo("n(1)∅ cylinder");}
if (show==1){cube(10,true);echo("10mm Cube");}

}





module Drehpunkt(rx=0,ry=0,rz=0,x=0,y=0,z=0,messpunkt=1)
{
    translate([x,y,z])rotate([rx,ry,rz])translate([-x,-y,-z])children();
    if(messpunkt)
    {
        if(rz)%color("blue")translate([x,y,z])cylinder(20,d=.5,center=true);
        if(ry)%color("green")translate([x,y,z])rotate([0,0,rz])rotate([90,0,0])cylinder(20,d=.5,center=true);
        if(rx)%color("red")translate([x,y,z])rotate([rx,ry,rz])rotate([0,90,0])cylinder(20,d=.5,center=true);   
        %color("yellow")translate([x,y,z])sphere(d=1);
    }
}




module Rohr(grad=90,rad=5,d=8,l1=10,l2=12,fn=fn,rand=n(2))
{
    difference()
    {
        Bogen(grad=grad,rad=rad,d=d,l1=l1,l2=l2,fn=fn);
        Bogen(grad=grad,rad=rad,d=d-rand*2,l1=l1+1,l2=l2+1,fn=fn);
    }
}



module Klon(tx=10,ty=0,tz=0,rx=0,ry=0,rz=0)
{
    
 translate([tx,ty,tz])rotate([rx,ry,rz])children();  
 translate([-tx,-ty,-tz])rotate([-rx,-ry,-rz])children();     
     
}









module Halb(i=0,x=0,y=0,z=0)
{
   if(i)difference()
   {
       children();
     R(x?90:0,y?90:0)  cylinder(200,d=200,$fn=6);
      
   }
  if(!i) intersection()
  {
      children();
      R(x?90:0,y?90:0)  cylinder(200,d=200,$fn=6);
  }
   
    
}



module Kugelmantel(d=20,rand=n(1),fn=fn)
{
    difference()
    {
        sphere(d=d,$fn=fn);
        sphere(d=d-2*rand,$fn=fn);
        
    }
}
    
    
   








module Kegelmantel(d=10,d2=5,v=1,rand=n(2),loch=4.5)
{
    difference()
    {
        Kegel(d1=d,d2=d2,v=v);
       T(z=-.01) Kegel(d1=d-2*rand,d2=0,v=v);
        cylinder(100,d=loch);
    }
    
    
}

module Gardena(l=+10)
{
    T(z=1)Kehle(rad=1,dia=19.8);
    rotate_extrude(convexity=5,$fn=fn)
    {
        
        T(8-1.5,23.5)circle(r=1.5);//16 mm rund ende
        difference()//Dichtungsnut
        {
        T(5.0,15)square([3.00,8.5]);
        T(8.0,20.5)circle(d=3.2);    
        }
        
        difference()//Kehle
        {
            T(5)square([4.9,15]);
            T(17.5,11.6)circle(r=10);
            polygon([[0,0],[0,30],[9.0,0]]);
            
        }
        
        T(7.12,15.5)rotate(45/2)circle(1.5,$fn=8);//Fase Dichtung
        
        T(5,15)square([8.5-5,1]);//17mmDichtrand
        
        
        T(9.5)square([15-9.5,1]);//30mmRand
        T(9.5)square([9.9-9.5,5]);//20mmRand
        difference()
        {
         T(9.5)mirror([0,1])square([15-9.5,l]);//30mmKörper
          polygon([[+0,-15],[+0,+0],[+21,-20]]);
          polygon([[+13,-10],[+16,-5],[+20,-20]]);  
            
        }
     
        
    }
}














module Kehle(rad=2.5,dia=0,l=20,angle=360,fn=fn,spiel=spiel)
{
	if(!dia)R(90)linear_extrude(height=l,$fn=fn)
    {
        difference()
        {
           translate([-spiel,-spiel]) square([rad+spiel,rad+spiel]);
            T(rad,rad)circle(rad);
        }
    }
	
	if(dia)	rotate_extrude(angle=angle,$fn=fn)
	T(dia/2)difference()
	{
		translate([-spiel,-spiel])square([rad+spiel,rad+spiel]);
		T(rad,rad)circle(rad);
	}	
	
	
	
		
	
}












module Col(n=0)
{
    
    color(co[n])children();
}



module Sinuskoerper
(
h=10,
d=33,
rand=2,
randamp=1,
amp=1.5,
w=4,
randw=4,
detail=3,
vers=0
)
{
    for (i=[0:detail:359.9])
        
    {
        j=i+detail;
        hull()
        {
           rotate(i) T(d/2+amp*sin(i*w))cylinder(h,d=rand+randamp*sin((i+vers)*randw),$fn=36);
           rotate(j) T(d/2+amp*sin(j*w))cylinder(h,d=rand+randamp*sin((j+vers)*randw),$fn=36);
        }
        
    }
    
}




module Achshalter
(
laenge=30,
achse=+5,
schraube=3,
mutter=5.5,
schraubenabstand=15,
hoehe=8,
fn=fn
)

difference()
{
    union()
    {
        minkowski()
        {
        T(-8+laenge/2-achse/2)cube([laenge+16+achse-schraube,achse+0,hoehe-1],center=true);
            cylinder(1,d=schraube,$fn=fn,center=true);
        }
        cylinder(hoehe,d=achse+10,$fn=fn,center=true);
    }
    T(0)cube([15+achse+schraubenabstand,2,hoehe+1],center=true);//Schlitz
    cylinder(50,d=achse,center=true,$fn=fn);//Motorachse
    R(90)T(z=-10)Twins(20,l=schraubenabstand+achse,d=schraube+2*spiel,center=1);//Schraubenlöcher
    T(-(schraubenabstand+achse)/2,-achse/2)Linear(s=schraubenabstand+achse)R(90)Inkreis(d=mutter+spiel*2);
}



module Dreieck(h=10,ha=10,s=1,n=1,c=0)
{
  r=(sqrt(3)/3)*ha/(sqrt(3)/2);
 T(c?h/2:0,z=c?ha/2-r:ha-r) R(0,-90) scale([1,s,1])cylinder(h=h,r=r,$fn=3); 
   if(n)echo(str("»»» »»» ",n," Dreieck Höhe= ", ha," Breite= ",ha/(sqrt(3)/2)*s," Winkel= ",2*atan(((ha/(sqrt(3)/2)*s)/2)/ha)            )); 
}




module Gewinde(d=20,s=1.5,w=5,g=1,fn=3,r=0,gd=1.75,detail=5,tz=0,n=1)
{
    difference()
    {
        children();
        color("orange")translate([0,0,tz])for (i=[0:detail:w*360])
            {
                j=i+detail;
                hull()
                {
                    R(z=i)Polar(g,(d-gd)/2,n=0)T(z=i/(360/s))R(90)R(z=r)cylinder(.1,d=gd,$fn=fn);
                    R(z=j)Polar(g,(d-gd)/2,n=0)T(z=j/(360/s))R(90)R(z=r)cylinder(.1,d=gd,$fn=fn);
                }
      
            }
    }
   
    if(n)echo(str("»»» »»» ",n," Gewinde aussen∅= ",d,"mm — Center∅= ",d-gd,"mm"));
    if(r||fn!=3) echo (" !!! Check Aussendurchmesser !!! ");   
    
}

module Bogen(grad=90,rad=5,d=3,l1=10,l2=12,n="1",fn=fn)
{
      color("green")T(rad,-0.01)R(-90)cylinder(l1+0.01,d=d,$fn=fn); 
      Torus(rad,d,a=-grad,n=0,fn2=fn);
      color("orange")R(z=-grad-180) T(-rad,-0.01)R(-90,+0,0)cylinder(l2+0.01,d=d,$fn=fn);
  if(n)echo(str("»»» »»» ",n," Bogen ",grad,"° Durchmesser= ",d,"mm — Innenmaß= ",2*max(rad,d/2)-d,"mm Außenmaß= ",2*max(rad,d/2)+d));
    
}





module Imprint(txt1=1,radius=20,abstand=7,rotz=-2,h=l(2),rotx=0,roty=0,stauchx=0,stauchy=0,txt0=" ",txt2=" ")
{
    str1=str(txt0,txt1,txt2);
    echo(str1);
    for (i=[0:1:len(str1)])
    {
        rotate([0,0,i*abstand])translate([0,-radius,0])rotate([rotx,roty,rotz])linear_extrude(h+.005,convexity=10)
        {
            
            rotate([stauchx,stauchy,0])translate([+0,-0.2])mirror([0,1,0])text(str1[i],size=5,$fn=45,halign="center",valign="baseline");
        }
    }
}


module W5(kurv=15,arms=3,detail=.3,h=50,tz=+0,start=0.7,end=13.7,topdiameter=1,topenddiameter=1,bottomenddiameter=+2,inv=0)
{

    Polar(e=arms)for (i=[start:detail:end])
    {
        
        
        j=i+detail;
        hull()
        {
            R(z=i*kurv)T(i,0,tz*-2*h/(2*PI*(i)))R(inv*180)cylinder(h/(2*PI*(i)),d1=n(topenddiameter)+i/end*n(bottomenddiameter),d2=n(topdiameter),$fn=fn);
            R(z=j*kurv)T(j,0,tz*-2*h/(2*PI*(j)))R(inv*180)cylinder(h/(2*PI*(j)),d1=n(topenddiameter)+j/end*n(bottomenddiameter),d2=n(topdiameter),$fn=fn);
        }
    }
 

}




module Text(text="»«",size=5,h=0,cx=0,cy=0,cz=0,center=0,fn=fn,radius=0)
{
    h=h?h:size;
    cx=center?1:cx;
    cy=center?1:cy;
    cz=center?1:cz;
    
    translate([0,0,cz?-h/2:0]) linear_extrude(h,$fn=fn,convexity=10)
    {
        
    text(text,size=size,halign=cx?"center":"left",valign=cy?"center":"baseline",font="DejaVusans:style=bold");
    }
}




module Bitaufnahme(l=10)
{
    
   hull()
    {
        cylinder(l,d=Inn6eck(6.3),d2=Inn6eck(6.1),$fn=6);
        T(z=l)R(0)sphere(d=Inn6eck(5.5),$fn=36);
    }
    
   T(z=-.01)color("red")Kegel(d1=Inn6eck(6.5),d2=Inn6eck(6.1),v=+43.31,fn=6,n=0); 
    
}

//Schnitt(r=0)Luer(0);
//T(z=0)Schnitt(r=0)Luer(1,0);
//T(z=+0.2)Schnitt(r=0)Luer(1,1,0);
//%T(z=1.2)cylinder(1,d=7.6);

module Luer(male=1,lock=1,slip=1)
{
    //show=41; 6% nach DIN
    *R(180)T(z=-73.5)color("red")cylinder(100,d1=0,d2=6,$fn=fn);//Eichzylinder 6%
    *T(z=+1.0)color("green")cylinder(5.8,d1=4.35,d2=4.0,$fn=fn);//referenz gemessen
    
    d=4.45;
    
    if (male)
    {
        if(slip)
        {
            translate([0,0,lock?0:-1])difference()
            {
                Kegel(d1=lock?d:d+.06,d2=4,v=+33,n=0);
                translate([0,0,-0.1])Kegel(d1=d-n(2),d2=4-n(2.2),v=+33,n=0);
                echo(str("»»»  »»» Luer uses Kegel(d1=",d,",d2=4,v=+33);"));
            }
            intersection()
            {
                Ring(.5,1,5.7,n=0);
                Kegel(d2=4,d1=6.0);
            }
        }
        
        
        if (lock)
        {
         T(z=6)Gewinde(d=8.85,w=1.4,s=5.5,g=2,gd=In4eck(1.3),fn=5,r=36,tz=-6.4,n=0)R(180)Ring(6,1.9,10.2,n="Luerlock");
            difference()
            {
                Ring(.5,2.5,10,n=0);
               translate([0,0,-0.15]) Kegel(d2=4,d1=6.0);
            }
        }
    }
    
    if (!lock&&!slip)color("orange")cylinder(10,d=10.5,$fn=fn);
    
    if (!male)
    {
      
        T(z=0)difference()
        {
        union()
            {
               if(lock) rotate(360/5.5*0.3)Gewinde(d=7.8,w=0.5,s=5.5,g=2,gd=1.2,fn=5,r=36,tz=-0.7,n=0);
               if(slip) Ring  (10,n(2),6,n=0);
            }
            translate([0,0,-0.1])Kegel(d1=6-n(2),d2=2.0,v=+33,n=0);
            mirror([0,0,1])cylinder(5,d=12);
        
        }
        
    }
    
    
    
    
    
}




module Knochen(l=+15,d=3,d2=5,b=0,fn=fn)

{
    f=50/fn*0.3;
    function m(x)=d+pow(1.5,x);
    for(i=[-l:f:+5])
    {
        hull()
        {
        R(i*b)T(z=i)scale([d2/m(i),1,1])R(i*b)cylinder(.01,d=m(i),$fn=fn);
        R((i+f)*b)T(z=i+f)scale([d2/m(i+f),1,1])R((i+f)*b)cylinder(.01,d=m(i+f),$fn=fn);
        }
    }
    
    
    
    
}

module Aussenkreis(h=5,d=5.5,eck=6,kreis=0,fn=150,n=1)
{
    echo("!!!!!!!!!!!!!!!!!! Renamed Inkreis");
    Inkreis(h=h,d=d,eck=eck,kreis=kreis,fn=fn,n=n);
    echo("!!!!!!!!!!!!!!!!!! Renamed USE Inkreis");
}

module Inkreis(h=5,d=5.5,eck=6,kreis=0,fn=fn,n=1)
{
    
    if(eck==8){
        a=d*(sqrt(2)-1);
        
        
        R(z=180/8)cylinder(h,r=a*sqrt(1+(1/sqrt(2))),$fn=kreis?fn:eck);  
    }  
    
    if(eck==6)cylinder(h,d=In6eck(d),$fn=kreis?fn:eck);
    
    if(eck==4)R(z=45)cylinder(h,r=sqrt(2*pow(d/2,2)),$fn=kreis?fn:eck);
    if(eck==3)R(z=0)cylinder(h,r=d,$fn=kreis?fn:eck);
    
    if(n)echo(str("»»» »»» ",n," ",eck,"-eck Inkreis∅= ",d));
}

module DGlied0(l1=12,l2=12,la=1.5)
{
    Glied(l1,la=la);
    mirror([0,1,0])Glied(l2,la=la);
}

module DGlied1(l1=12,l2=12,la=+1.5)
{
    mirror([+0,1,0])T(0,-l1)Glied(l1,la=la);
    T(0,-l2)Glied(l2,la=la);
}


module Glied(l=12,spiel=0.5,la=+1.5,fn=20)

{
    T(y=l,z=2.5)Torus(1.2,1.7,fn=fn);
        if (messpunkt)
        {
            %color ("blue")translate([0,l,0.1])R(z=180/12)cylinder(l(90), d1=1,d2=1,$fn=12,center=true);//messachse1
            %color("red")cylinder(l(90), d1=1,d2=1,$fn=12,center=true);//messachse2
        }
        
        
        T(0,l)//kopfstück
        {
            T(0,1.2-l/2.53,2.5) minkowski()
            {
                cube([+1.5,l*0.8-4.75,+0.01],true);
                sphere(0.8,$fn=fn);
            } 
            cylinder(5,d=n(5),$fn=150);//Achse!
        }
   difference()
   {
       T(0,la,2.5)hull()//Ringanker
      {
               T(0,l/2-4.0-la/2) minkowski()
        {
            cube([1.0,l-6.0+la,3.40],true);
            sphere(0.8,$fn=fn);
        } 
                      T(0,l-6) minkowski()
        {
            cube([+1.0,0.1,+0.01],true);
            sphere(0.8,$fn=fn);
        } 

        
      } 
       
        
        
        
        T(+0,-0.5)cylinder(15,d=n(7)+2*spiel,$fn=fn,center=true);
        Freiwinkel(); 
    }
    
    T(0,0)union()//B ring
    {
        difference()
        { 
            union()
            {
                Ring(5,n(1),n(7)+2*spiel);
                *T(0,3.2)R(z=33)cylinder(5,d=3,$fn=3);
                
            }
            color("red")Freiwinkel(); 
                              * T(+2.9,-1.40,2.5)R(z=46)minkowski()
                            {
                                cube([5,+5,1.0],true);
                                sphere(1.0,$fn=fn);
                            }
                                
                            *mirror([1,0,0])  T(+2.9,-1.40,2.5)R(z=46)minkowski()
                            {
                                cube([5,+5,1.0],true);
                                sphere(1.0,$fn=fn);
                            }
           
            
        }
        
        *T(0,+5.2,2.50)minkowski()
        {
            cube([0.6,+6.0,4],true);
            sphere(.5,$fn=fn);
        }  
        
    }
   
 module Freiwinkel(w=116)//Glied only
 T(0,+1.0){
  R(z=+w) T(-6,+0,2.0)minkowski()
            {
                cube([20,+5,1.0],false);
                sphere(0.8,$fn=fn);
            }    
   R(z=-w) T(-14,+0,2.0)minkowski()
            {
                cube([20,+5,1.0],false);
                sphere(0.8,$fn=fn);
            }      

 }   
    
    
}


module Freiwinkel(w=60,h=1)
 T(0,+1.0){
  R(z=w/2-90) T(-6,+0,2.0)minkowski()
            {
                cube([20,5,h],false);
                sphere(0.8,$fn=fn);
            }    
   R(z=-w/2+90) T(-14,+0,2.0)minkowski()
            {
                cube([20,5,h],false);
                sphere(0.8,$fn=fn);
            }      

 }


module Pille(l=10,d=5,fn=fn,center=1,n=1,s=0)
{
 //show=35;
    d=s?s:d;//abwärts compabilät 
    hull()
    {
        translate([0,0,center?+l/2-d/2:l-d/2])rotate([0,0,0])sphere(d=d,$fn=fn);
        translate([0,0,center?-l/2+d/2:d/2])sphere(d=d,$fn=fn);
        
    }
    if(n)echo(str("»»» »»» ",n," Pille Länge= ",l," sphere∅= ",d));
}


module Torus(trx=+6,d=4,a=360,fn=fn,fn2=fn,r=0,n=1)
{
  
    rotate_extrude(angle=a,$fn=fn,convexity=5) T(x=max(trx,d/2))R(0,0,r)circle(d=d,$fn=fn2);
    
    if(n)echo(str("»»» »»» ",n," Torus Innen∅= ",2*max(trx,d/2)-d," Aussen∅= ",2*max(trx,d/2)+d));
    
}
    




module Torus2(m=10,trx=10,a=1,rq=1,d=5,w=2,n=1)//m=feinheit,trx = abstand mitte,a = sin verschiebung , rq=mplitude, w wellen
{

rotate ([0,0,0])for (i=[0:m:360])
    { 

        hull()
        {
        rotate ([0,0,i])translate([trx+(sin(w*i)*a),0,0])rotate([90,0,0])cylinder(.01,d=sin(w*i)*rq+d,$fn=200/m,center=true);
        rotate ([0,0,i-m])translate([trx+(sin(w*(i-m))*a),0,0])rotate([90,0,0])cylinder(.01,d=sin(w*(i-m))*rq+d,$fn=200/m,center=true);
        } 
    }
 
  if(n)echo(str("»»» »»» ",n," Torus2 ",w," Wellen"));   

}



module Kegel(d1=12,d2=6,v=1,fn=fn,n=1,center=false)
{
//Basis
// Obererdurchmesser
//kegelverjüngung
cylinder ((d1-d2)/2*v,d1=d1,d2=d2,$fn=fn,center=center);
 if (n)echo(str("»»»››› ",n," Konushöhe=",(d1-d2)/2*v," Steigung= ",v*100," % ",atan(v),"°"));
}

module MK(d1=12,d2=6,v=19.5,fn=fn)
{
//Basis
// Obererdurchmesser
//kegelverjüngung
cylinder ((d1-d2)/2*v,d1=d1,d2=d2,$fn=fn);
 echo(str("»»»››› Konushöhe=",(d1-d2)/2*v));
}



module T(x=0,y=0,z=0)
{
    translate([x,y,z])children();
}

module R(x=0,y=0,z=0)
{
    rotate([x,y,z])children();
}



module Stabhalter (l=10,d=3.5)// Replaced with Ring(cd=-1,rand(n(1.5)),durchmesser=In6eck(3.1),fn=6)
{
    
    
    
    translate([+0.0,0,2.165])difference()
    {
        rotate ([0,90,0])rotate ([0,0,30]) cylinder(l,d=d+n(3),$fn=6);
        translate([+0.5,0,0])rotate ([0,90,0])rotate ([0,0,30]) cylinder(l+5,d=d,$fn=6);
    }
    
    echo("Removed!  Verschoben wegen nozzle∅! Use T(z=3.1/2)R(0,90)Inkreis(d=3.1) or Ring(cd=-1,rand(n(1.5)),durchmesser=In6eck(3.1),fn=6)");
}

module Halbrund(h=10,d=3+2*spiel,x=1.0-spiel,n=1)
{
              
difference()
{
  children();   
  difference()
    {
        cylinder(d=d,h=h*2,center=true,$fn=60);
        translate([d/2-x, -25, -50])cube([50,50,100],center=false);
    }
}
  if (n)echo(str("»»»››› ",n," Halbrund l= ",h," ∅= ",(d)," Abgeflacht um= ",x));   
    
}

module Twins(h=1,d=0,d11=10,d12=10,d21=10,d22=10,l=20,r=0,fn=fn,center=0,sca=+0)
{
    d11=d?d:d11;
    d12=d?d:d12;
    d21=d?d:d21;
    d22=d?d:d22;
    rotate([0,0,center?r:0])translate([center?-l/2:0,0,0]){
    rotate([0,-sca,0])cylinder(h,d11*.5,d12*.5,$fn=fn);
    rotate([0,0,center?0:r])translate([l,0,0])rotate([0,sca,0])cylinder(h,d21*.5,d22*.5,$fn=fn); }   
    
}



module Riemenscheibe(e=40,radius=25,nockendurchmesser1=2,nockendurchmesser2=2,hoehe=8)

{
   echo(str("Nockenabstand= ",2*PI*radius/e));
   difference()
   {
        children();
    
      Polar(x=radius,e=e,n=0)translate([00,0,-.005])cylinder(.01+hoehe,d=nockendurchmesser2,center=false,$fn=36);
   }  
    
   Polar(x=radius,e=e,r=180/e,n=0)cylinder(hoehe,d=nockendurchmesser1,center=false,$fn=36);   
     
}

module Servokopf()
{
    d2=+6.15;
    d1=6.2;
    fn=3;
    difference()
    {
        union()
        {
            children();
            
        }
        for (i=[0:360/4:359])
        {
         rotate([0,0,i]) translate([0,0,-.1])cylinder(3.5,d1=d1,d2=d2,$fn=fn,center=false);   
            
        }
        translate([0,0,-0.01])cylinder(.5,d1=d1-0.1,d2=d1-2,$fn=36,center=false);//basekone
        *cylinder(6,d1=d1,d2=d2,$fn=fn,center=true);
        *rotate([0,0,360/2*fn])cylinder(6,d1=d1,d2=d2,$fn=fn,center=true);
        cylinder(10,d=2,$fn=36); //SchraubenlochNarbe 
         translate([0,0,3.4+1])cylinder(100,d=4.5,$fn=36); //SchraubenKopflochNarbe 
          translate([0,0,-30.01])cylinder(30,d=50,$fn=36); //Servo
      
    }
}

    
module Servo(r=0,narbe=1)
 {
     
     cube([12.5,22.5+1.5,23],true);
     
     
     translate([+0,0,(-23/2+2.5/2)+16])cube([12.5,32.5,2.5],true);
     color([.8,0.4,.6,1])translate([+0,-5,2.8])cylinder(26.0,d1=12,d2=12,$fn=36,center=true);
       color([.8,0.3,.6,1])translate([+0,+0.7,2.7])cylinder(26.0,d=5.5,$fn=36,center=true);  
     color([.8,0.3,.6,1])translate([+0,+1.4,2.7])cylinder(26.0,d=5.5,$fn=36,center=true);
     color([.8,.8,.6,1])translate([+0,-5,3.5])cylinder(30.0,d=5,$fn=12,center=true);
     if (narbe==1)
         { translate([+0,-5,17.3])rotate([+0,0,66-90+r])scale([0.2,1.0,1])cylinder(3,d=35,center=true); // servoarm Oval
             translate([+0,-5,17.3])rotate([+0,0,66-90+r])cube([18,4.1,3.0],true);//servoarm
         }
        if (narbe==2)
         { translate([+0,-5,18.2])rotate([+0,0,66-90+r])scale([1,1,1])color([.8,.8,.8,0.5])cylinder(6,d=35,center=true); // servoarm Rund        
     
         }
     if (narbe==3)
         {
             color([.8,.8,.8,1])translate([+0,-5,49])cylinder(70,d1=4,d2=4,$fn=36,center=true);//Mitte Drehachse 
         }
     color([.8,0.5,.2,1])translate([+0,-11.8,-3.4])scale([1,0.15,1])cylinder(16,d=12.5,$fn=36,center=true);//cut für kabel
        translate([+0,14,6]) cylinder(10.0,d=1.8,$fn=6,center=true);    //Schraubenlöcher 
         translate([+0,-14,6]) cylinder(10.0,d=1.8,$fn=6,center=true);    //Schraubenlöcher     
 }    
module Glied3(x)

{
    difference()
    {
        union()
        {
        
            color("blue")translate([x,0,l(1)]) cylinder(l(13),d1=1.9,d2=1.9,$fn=69,center=false);//Achse
            translate([x,0,l(1)])cylinder(l(5), d1=3.5,d2=2.0,$fn=69,center=false);//unten Sockel
            translate([x,0,l(11)])cylinder(l(3), d1=2,d2=3.5,$fn=69,center=false);//oben Sockel 
        }
         translate([x,+0,0])rotate([0,0,0])cylinder(l(40),d=+0.75,$fn=96,center=true);//achslochloch
    }
    if (messpunkt)
        {
            %color ("blue")translate([x,0,0.1])cylinder(l(40), d1=1,d2=1,$fn=12,center=true);//messachse1
            %color("red")cylinder(l(40), d1=1,d2=1,$fn=12,center=true);//messachse2
        }
   difference()
    {
           hull()
           {
            translate([0,0,0.0])cylinder(l(14),d=4.5,$fn=69,center=false); 
            translate([x,0,0])cylinder(l(+18), d1=+3.5,d2=+3.5,$fn=69,center=false);   
           }

       translate([+0.0,0,l(+1)])rotate([0,6,0])cylinder(l(9),d1=6.1,d2=2.2,$fn=69,center=false);//Kegel ausschnitt unten
       translate([0,0,l(+0)-0.05])rotate([0,0,0])scale([1,1,0.47])sphere(d=5.9,$fn=69,center=false);//Kegel ausschnitt untendrunter grade
       color("red")translate([0,0,-0.01])cylinder(5,d=3.00,d2=3.00,$fn=69,center=false);//achsloch
      * color("green")translate([0,0,l(11)+.01])cylinder(l(7),d=+2.0,d2=8.0,$fn=69,center=false);//lagerfläche oben
        translate([0,0,l(+19)-0.05])rotate([0,0,0])scale([1,1,0.47])sphere(d=5.9,$fn=69,center=false);//oben Frei
       mirror([0,0,0])translate([x,+0,l(3)])rotate([0,0,0])cylinder(l(5),d1=+6.0,d2=7.0,$fn=96,center=false);//lagerfläche innen unten
       translate([x,+0,l(+8)-0.01])rotate([0,0,0])cylinder(l(6),d1=+7.0,d2=6.0,$fn=96,center=false);//lagerfläche innnen oben
           
       translate([x,+0,0])rotate([0,0,0])cylinder(l(45),d=+0.60,$fn=96,center=true);//achslochloch
   }
   
} 
module Gelenk(l,w)//ausschnittlänge, winkel
{
    scale([1.2,1.2,1.3])rotate([0,0,180])intersection()
    {
        union()
        {
            translate([-l,0,0])Glied3(l);
            translate([ 0,0,0])rotate([0,0,w])Glied3(l+10);
        }
        union()
        {
        translate([0,0,0])rotate([0,0,w])translate([l/2,0,0])resize([l,6,10])cylinder(10,d=5,$fn=3,center=true);
         translate([+0,0,0])cube ([14,11,30],center=true);
        }
       
    }    
}
//Ring(cd=+1,center=true);
module Ring(hoehe=5,rand=5,d=10,cd=1,center=false,fn=fn,n=1)// 
{

     if(cd==1){difference()//Aussendurchmesser
        {
            cylinder(hoehe,d=d,$fn=fn,center=center);
            translate([+0,0,0])cylinder(2*hoehe+1,d=d-2*rand,$fn=fn,center=true);
        }
        if(n)echo(str("»»»  »»» ",n," Ring Aussen∅= ",d,"mm — Mitte∅= ",d-rand,"mm — Innen∅= ",d-(rand*2),"mm groß und ",hoehe," hoch ««« «««"));}
            
     if(cd==0){difference()//Center durchmesser
        {
            cylinder(hoehe,d=d+rand,$fn=fn,center=center);
            translate([+0,0,0])cylinder(2*hoehe+1,d=d-rand,$fn=fn,center=true);
        }
        if(n)echo(str("»»»  »»» ",n," Ring Aussen∅= ",d+rand,"mm — Mitte∅= ",d,"mm — Innen∅= ",d-rand,"mm groß und ",hoehe," hoch ««« «««"));}        
            
         
     if(cd==-1){difference()//innen durchmesser
        {
            cylinder(hoehe,d=d+2*rand,$fn=fn,center=center);
            translate([+0,0,0])cylinder(2*hoehe+1,d=d,$fn=fn,center=true);
        }
        if(n)echo(str("»»»  »»» ",n," Ring Aussen∅= ",d+2*rand,"mm — Mitte∅= ",d+rand,"mm — Innen∅= ",d,"mm groß und ",hoehe," hoch ««« «««"));}          
         
}

module RingX(layer,rand,durchmesser)//old don't use! 
{
     
  echo("WARNING - DONT USE , REMOVED -- USE: Ring(hoehe=l(layer))");  
    difference()
        {
            cylinder(l(layer),d=durchmesser,$fn=250,center=false);
            translate([+0,0,-l(.5)])cylinder(l(layer+1),d=durchmesser-rand,$fn=250,center=false);
        }
}

module Schnitt(r=0,x=0,y=0,z=-0.01,on=1,rx=0,ry=0,sizex=200,sizey=200,sizez=50)
{
    difference(convexity=10)
    {
        children();
      if(on)  rotate([rx,ry,r-90])translate([y,x,z])color([1,0,0,1])cube([sizex,sizey,sizez]);
    }
  if (on)
      {
         echo("   »»»»»»»»»»»»»»»»»»––SCHNITT––««««««««««««««««««««««««««« ");
         echo(" «««««««««««««««««««––SCHNITT––»»»»»»»»»»»»»»»»»»»»»»»»»»»» "); 
         echo("   »»»»»»»»»»»»»»»»»»––SCHNITT––««««««««««««««««««««««««««« ");
         echo();
      }          

}
module Polar(e=3,x=0,y=0,r=0,re=0,n=1,end=360,dr=0)// ordnet das Element 20× im Radius x kreisförmig(360) an
{

rotate([0,0,r])for (i=[+0:end/e:end-1])
         {
            rotate([0,0, i])translate([x,y,0])rotate([0,0, re+i/end*dr])children();
             
         } 
if(n)echo(str("»»»››› ",n," Polar ×",e," transX= ",x," transY= ",y," rotElements= ",re," End= ",end," Element °= ",end/e));
}

*Linear(es=0.5,s=1.0,e=4,x=90,y=0,z=0,r=0,re=0,center=+1,cx=+0)cube(5);
module Linear(es=1,s=100,e=2,x=1,y=0,z=0,r=0,re=0,center=0,cx=0,cy=0,cz=0)// ordnet das Element 20× im Abstand x Linear an.. es skaliert die vektoren . cx = center x
{

    cx=center?1:cx;
    cy=center?1:cy;  
    cz=center?1:cz;
translate([cx?-x*es/2*s:0,cy?-y*es/2*s:0,cz?-z*es/2*s:0])for (i=[+0:s?s/(e-1):es:s?s:es*(e-1)])
         {
            rotate([0,0, r])translate([i*x*es,i*y*es,i*z*es])rotate([0,0, re])children();
             
         } 
}

module Servotraeger(SON=1)translate([0,+0,+35.4])
 {
     difference()
     {
         minkowski()
         {
             translate([-11,+0,-33.9]) cube([29,20,3],center=true);
             cylinder(1,d=5,$fn=36);
         }
        if(SON) #translate([-11,0,-40]) rotate([0,0,-90])Servo(22);
            else translate([-11,0,-40]) rotate([0,0,-90])Servo(22);
          * mirror([0,1,0])translate([-11,-30,-40]) rotate([0,0,-90])Servo();
     }
                              
                *minkowski()//Sockel
                 {
                     translate([+2,+0,-27.4]) cube([15,9,16],center=true);
                     cylinder(1,d=5,$fn=36);
                 }


   }
   echo("———————————————————————————————————————————");