@ECHO OFF
CLS
SETLOCAL ENABLEEXTENSIONS

SET $me=%~n0
SET $parent=%~dp0

SET $PlinkPath=%ProgramFiles(x86)%\PuTTY\plink.exe
SET $GitPath=%ProgramFiles%\Git

:: Elevate Batchfile
FSUTIL dirty query "%SYSTEMDRIVE%" >nul
IF NOT %ERRORLEVEL% equ 0 (
    ( ECHO SET UAC = CreateObject^("Shell.Application"^)
        ECHO UAC.ShellExecute "%~dpf0", "%*", "", "runas", 1
    )> "%TMP%\CmdGetPrivileges.vbs"
    START /WAIT "" "%TMP%\CmdGetPrivileges.vbs"
    DEL "%TMP%\CmdGetPrivileges.vbs"
    EXIT /B
)

IF NOT EXIST "%$parent%GitInstall.inf" (
	ECHO Could not find GitInstall.inf - creating one
	CALL :CreateInf
	ECHO Change Options in the GitInstall.inf to your liking and run the "%$me%" again.
	SET $AksForEdit=1
	CHOICE /M "Do you want to edit the just created GitInstall.inf now?"
)

IF NOT DEFINED $AksForEdit GOTO :SkipEdit
	IF %ERRORLEVEL% EQU 1 START notepad "%$parent%gitinstall.inf"
	EXIT /B
:SkipEdit

FOR /F "usebackq delims== tokens=2*" %%A IN (`TYPE "%$parent%gitinstall.inf" ^| FIND /i "Dir="`) DO SET $GitPath=%%A
FOR /F "usebackq delims== tokens=2*" %%A IN (`TYPE "%$parent%gitinstall.inf" ^| FIND /i "PlinkPath="`) DO SET $PlinkPath=%%A

:: Get GitInstaller
FOR /F "usebackq" %%A IN (`dir /A-L-D /B /ON git*.exe`) DO SET $GitInstaller=%%A

START "%$GitInstaller%" /LOADINF="%$Parent%GitInstall.inf" /SILENT

GOTO :EOF

:CreateInf
	ECHO [Setup] > "%$Parent%GitInstall.inf"
	ECHO Lang=default >> "%$Parent%GitInstall.inf"
	ECHO Dir=%$GitPath% >> "%$Parent%GitInstall.inf"
	ECHO Group=Git >> "%$Parent%GitInstall.inf"
	ECHO NoIcons=0 >> "%$Parent%GitInstall.inf"
	ECHO ;NoIcons=1 >> "%$Parent%GitInstall.inf"
	ECHO SetupType=default >> "%$Parent%GitInstall.inf"
	ECHO Components=ext,ext\shellhere,assoc,assoc_sh >> "%$Parent%GitInstall.inf"
	ECHO ;Components=ext,ext\shellhere,ext\guihere,assoc,assoc_sh,consolefont >> "%$Parent%GitInstall.inf"
	ECHO Tasks= >> "%$Parent%GitInstall.inf"
	ECHO.  >> "%$Parent%GitInstall.inf"

	ECHO PathOption=Cmd >> "%$Parent%GitInstall.inf"
	ECHO ;PathOption=BashOnly >> "%$Parent%GitInstall.inf"
	ECHO ;PathOption=CmdTools >> "%$Parent%GitInstall.inf"
	ECHO.  >> "%$Parent%GitInstall.inf"
	
	ECHO ;SSHOption=OpenSSH >> "%$Parent%GitInstall.inf"
    ECHO PlinkPath=%$PlinkPath% >> "%$Parent%GitInstall.inf"
	ECHO SSHOption=Plink >> "%$Parent%GitInstall.inf"
	ECHO.  >> "%$Parent%GitInstall.inf"
	
	ECHO CRLFOption=CRLFAlways >> "%$Parent%GitInstall.inf"
	ECHO ;CRLFOption=CRLFCommitAsIs >> "%$Parent%GitInstall.inf"
	ECHO ;CRLFOption=LFOnly  >> "%$Parent%GitInstall.inf"
	ECHO.  >> "%$Parent%GitInstall.inf"
	
	ECHO BashTerminalOption=MinTTY >> "%$Parent%GitInstall.inf"
	ECHO ;BashTerminalOption=ConHost >> "%$Parent%GitInstall.inf"
	ECHO.  >> "%$Parent%GitInstall.inf"
	
	ECHO PerformanceTweaksFSCache=Enabled >> "%$Parent%GitInstall.inf"
	ECHO ;PerformanceTweaksFSCache=Disabled >> "%$Parent%GitInstall.inf"
EXIT /B