#include <iostream>
#include <errno.h>
#include <string.h>

#include "rs232lib.h"
using std::cout;
using std::endl;

int main()
{
	rs232lib::Rs232 serial;
	try
	{
		serial.Open("/dev/ttyUSB0",1000000);
		unsigned char* text=(unsigned char *)"test";
		if(!serial.Write(text,4))
		{
			cout<<"write: error "<<errno<<" : "<<strerror(errno)<<endl;
		}
		// reading
		unsigned char buf[256];
		while(true)
		{
			int len=serial.Read(buf,255);
			if(len==-1)
			{
				if(errno==EAGAIN)	// empty fifo	
					sleep(1);
				else
				{
					cout<<"read: error "<<errno<<" : "<<strerror(errno)<<endl;
					break;
				}
			}
			else
			{
				buf[len]='\0';
				cout<<buf<<endl;
			}
		}
		serial.Close();
	}
	catch(rs232lib::Rs232Exception e)
	{
		cout<<"error: "<<e.what()<<endl;
	}
}
